/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.tsd;

import com.ibm.hwmca.base.tsd.TsdErrorIds;
import com.ibm.hwmca.base.util.BaseFileControl;
import com.ibm.hwmca.base.util.SimServer;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.bridge.NativeBridge;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.log.Log;
import com.ibm.hwmca.fw.log.MicrocodeLogAttributes;
import com.ibm.hwmca.fw.rsf.RsfRequest;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.FileUtilities;
import com.ibm.hwmca.fw.util.GlobFilenameFilter;
import com.ibm.hwmca.fw.util.HexString;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.rsf.TransmitDataRequestBody;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TransmitSvcDataUtils
implements TsdErrorIds {
    private static final String TRACE_MASKT = "XTSDUTLT";
    private static final String TRACE_MASKF = "XTSDUTLF";
    private static final String TRACE_MASKD = "XTSDUTLD";
    public static boolean SE = false;
    public static boolean HMC = false;
    public static boolean TKE = false;
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-44, "TransmitSvcDataUtils");
    private static MicrocodeLogAttributes infoLog = MicrocodeLogAttributes.INFO_LOG;
    private static final String CUD_FILE_PATTERN = "cduffdc_*";
    private static final String CUD_FILE_PATH_PATTERN = "cduffdc_*";
    private static String CUD_ZIP_FILE = "iqyscdu.zip";
    private static final String CKS_FILE_PATTERN = "bbrcmr??.???";
    private static final String CKS_FILE_PATH_PATTERN = "bbrcmrc?.dat";
    private static String CKS_ZIP_FILE = "iqyschks.zip";
    private static String ACTP_ZIP_FILE = "iqyscaps.zip";
    private static final String ACTP_FILE_PATTERN = "iqzb*.dat";
    private static final String ACTP_FILE_PATH_PATTERN = "iqzb????.dat";
    private static String LPARZ_ZIP_FILE = "iqyslpzn.zip";
    private static final String LPARZ_FILE_PATTERN = "iqzqzg*.dat";
    private static final String LPARZ_FILE_PATH_PATTERN = "iqzqzq??.dat";
    private static String LICCC_ZIP_FILE = "iqyslicc.zip";
    private static final String[] LICCC_PATTERN = new String[]{"BBPUT*.DAT", "bbrefl*.trm", "BBRUC*.DAT"};
    private static final String[] LICCC_FILE = new String[]{"BBCIFPCR.DAT", "BBRCDL3C.DAT", "IQYVLICS.DAT", "iqyvpd.dat", "BBMIOLCC.TXT"};
    private static String LPRDMP_TRM_FILE = "iqyslpar.trm";
    private static final String LPRDMP_FILE_PATTERN = "iqzqd???.zip";
    private static final String[] LPRDMP_FILES = new String[]{"iqzqdlp1.zip", "iqzqdlp2.zip", "iqzqblpr.zip"};
    private static String CECD_TRM_FILE = "iqyscecd.trm";
    private static final String CECD_FILE_PATTERN = "bbrsdp??.zip";
    private static final String[] CECD_FILES = new String[]{"bbrsdp00.zip", "bbrsdp01.zip"};
    private static String CFDMP_TRM_FILE = "iqyscf12.trm";
    private static final String CFDMP_FILE_PATTERN = "iqzqccf.zip";
    private static final String[] CFDMP_FILES = new String[]{"iqzqccf1.zip", "iqzqccf2.zip"};
    private static byte[] nulls = new byte[]{0};
    private static String nullByte = new String(nulls);
    private static String blanks12 = "            ";
    private String[] _miscDataArray = null;
    private RsfRequest tsdRequest = null;
    private boolean TSAD = false;
    boolean reset = false;
    boolean satisfactoryCompletion = false;
    static Object tsdFileLock = new Object();
    private static int outstandingRequests = 0;
    private static FileCounter iqyslogCounter = new FileCounter();
    private static FileCounter iqyye4tpCounter = new FileCounter();
    private static FileCounter iqysvpdCounter = new FileCounter();
    private static FileCounter iqyscompCounter = new FileCounter();
    private static FileCounter acuscudCounter = new FileCounter();
    private static FileCounter vretainCounter = new FileCounter();
    private static FileCounter iocdsCounter = new FileCounter();
    private static FileCounter truncLogCounter = new FileCounter();
    private static FileCounter cudCounter = new FileCounter();
    private static FileCounter cksCounter = new FileCounter();
    private static FileCounter actpCounter = new FileCounter();
    private static FileCounter lparzCounter = new FileCounter();
    private static FileCounter licccCounter = new FileCounter();
    private static FileCounter lprdmpCounter = new FileCounter();
    private static FileCounter cecdCounter = new FileCounter();
    private static FileCounter cfdmpCounter = new FileCounter();
    private static FileCounter sadCounter = new FileCounter();
    static FileCounter tempDirCounter = new FileCounter();
    static String blanks100 = "                                                                                                     ";
    private static NumberFormat nf2 = NumberFormat.getInstance();
    private static NumberFormat nf4 = NumberFormat.getInstance();
    private static NumberFormat nf5 = NumberFormat.getInstance();

    public static Object methodCall(String data) {
        Object returnVal;
        Method implMethod;
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::methodCall() " + data);
        String parms = data;
        StringTokenizer tokens = new StringTokenizer(parms);
        if (tokens.countTokens() < 2) {
            return "TsdUtils: method name or parm missing";
        }
        String methodName = tokens.nextToken();
        String setupVal = tokens.nextToken();
        String completionVal = "N";
        if (tokens.hasMoreTokens()) {
            completionVal = tokens.nextToken();
        }
        TransmitSvcDataUtils tsdUtil = new TransmitSvcDataUtils();
        if (setupVal.equalsIgnoreCase("R")) {
            tsdUtil.reset = true;
        } else {
            TransmitSvcDataUtils.startTsdFileProcessing();
        }
        Class<?> implClass = tsdUtil.getClass();
        try {
            implMethod = implClass.getDeclaredMethod(methodName, null);
        }
        catch (Exception e) {
            return "TsdUtils: method '" + methodName + "' not found";
        }
        try {
            returnVal = implMethod.invoke((Object)tsdUtil, null);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.methodCall exception", e, true);
            returnVal = "TsdUtils. error invoking method '" + methodName + "'.";
        }
        if (tsdUtil.reset) {
            TransmitSvcDataUtils.endTsdFileProcessing();
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::methodCall()");
        return returnVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int startTsdFileProcessing() {
        Object object = tsdFileLock;
        synchronized (object) {
            Trace.trace(TRACE_MASKT, "<> TransmitSvcDataUtils::startTsdFileProcessing() " + ++outstandingRequests);
            return outstandingRequests;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int endTsdFileProcessing() {
        Object object = tsdFileLock;
        synchronized (object) {
            if (--outstandingRequests > 0) {
                Trace.trace(TRACE_MASKF, "Tsd.endTsdFileProcessing has " + outstandingRequests + " outstanding requests signifying that there had been concurrent tsd requests");
            } else {
                int numLeft;
                if (outstandingRequests < 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing has " + outstandingRequests + " outstanding requests.", null, true);
                    outstandingRequests = 0;
                }
                if ((numLeft = iqyslogCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing iqyslogCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = iqyye4tpCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing iqyye4tpCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = iqysvpdCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing iqysvpdCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = iqyscompCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing iqyscompCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = tempDirCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing tempDirCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = vretainCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing vretainCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = iocdsCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing iocdsCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = truncLogCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing truncLogCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = cudCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing cudCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = cksCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing cksCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = actpCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing actpCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = lparzCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing lparzCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = licccCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing licccCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = lprdmpCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing lprdmpCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = cecdCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing cecdCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = cfdmpCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing cfdmpCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
                if ((numLeft = sadCounter.reset()) != 0) {
                    TransmitSvcDataUtils.logError("Error: Tsd.endTsdFileProcessing sadCounter is " + numLeft + " while no outstanding Tsd requests are left. Counter reset.", null, true);
                }
            }
            Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::endTsdFileProcessing() " + outstandingRequests);
            return outstandingRequests;
        }
    }

    public void setReset(boolean reset) {
        this.reset = reset;
    }

    public void setSatisfactoryCompletion(boolean satComplete) {
        this.satisfactoryCompletion = satComplete;
    }

    public void setRsfRequest(RsfRequest request) {
        this.tsdRequest = request;
    }

    public void setTsad(boolean tsad) {
        this.TSAD = tsad;
    }

    public void setPeData(String[] peData) {
        this._miscDataArray = peData;
    }

    public void errorLogs() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::errorLogs()");
        try {
            this.lockedFileOp(iqyslogCounter, "iqyylog.log", "iqyslog.log", true);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.errorLogs: error copying file iqyylog.log to iqyslog.log", e, false);
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::errorLogs()");
    }

    public void e4Logs() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::e4Logs()");
        try {
            this.lockedFileOp(iqyye4tpCounter, "iqyye4.log", "iqyye4tp.log", true);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.e4Logs: error copying file iqyye4.log to iqyye4tp.log", e, false);
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::e4Logs()");
    }

    public void lastCompLog() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::lastCompLog()");
        try {
            if (!this.reset) {
                File[] filesArray = TransmitSvcDataUtils.getFilesList("iqyycom?.log");
                if (filesArray != null && filesArray.length > 0) {
                    File latestFile = filesArray[0];
                    for (int i = 0; i < filesArray.length; ++i) {
                        Date masterDate = new Date(latestFile.lastModified());
                        Date checkDate = new Date(filesArray[i].lastModified());
                        if (!checkDate.after(masterDate)) continue;
                        latestFile = filesArray[i];
                    }
                    this.lockedFileOp(iqyscompCounter, latestFile.getName(), "iqyscomp.log", true);
                }
            } else {
                this.lockedFileOp(iqyscompCounter, "", "iqyscomp.log", true);
            }
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.lastCompLog: error copying last log to iqyscomp.log", e, false);
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::lastCompLog()");
    }

    public void truncLog() {
        block7: {
            try {
                if (this.reset) {
                    this.lockedFileOp(truncLogCounter, "", "iqystlg.log", true);
                    break block7;
                }
                String fqFilename = "!" + BaseFileControl.getFilePath("iqystlg.log") + "iqystlg.log";
                NativeBridge bridge = new NativeBridge();
                bridge.registerObject(this, this.getClass().getName());
                NativeProcessParameters nativeProcessParameters = new NativeProcessParameters("actzNativeBridgeMain");
                Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.truncLog: Setup Native Bridge...)");
                bridge.exec(nativeProcessParameters);
                int jni_rc = 0;
                byte[] file_path = fqFilename.getBytes();
                Object[] args = new Object[]{this, file_path};
                try {
                    Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.truncLog: invokeNativeFunction(actzsp1)...)");
                    Object rc = bridge.invokeNativeFunction("actzsp1", "xlogTrimLog", args);
                    jni_rc = (Integer)rc;
                }
                catch (Exception exc) {
                    TransmitSvcDataUtils.logError("TransmitSvcDataUtils.truncLog: exception opening nativebridge connection", exc, false);
                }
                try {
                    Trace.trace(TRACE_MASKD, "TransmitSvcDataUtils.truncLog: Close NativeBridge...)");
                    bridge.close();
                }
                catch (Exception exct) {
                    TransmitSvcDataUtils.logError("TransmitSvcDataUtils.truncLog: Error closing NativeBridge connection = ", exct, true);
                }
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.truncLog: exception processing truncated log", e, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void probData() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::probData()");
        String parms = this.reset ? "acuppd.sh -c t" : "acuppd.sh -l t";
        int rc = -1;
        Object object = tsdFileLock;
        synchronized (object) {
            try {
                rc = RootProcess.executeProgram(parms);
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.probData exception executing acuppd.sh", e, false);
            }
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::probData() for " + parms + " rc=" + rc);
    }

    public void vretainFiles() {
        try {
            if (this.reset) {
                Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.vretainFiles() processing reset");
                File[] delFiles = TransmitSvcDataUtils.getFilesList("iqysv*.zip");
                if (delFiles != null && delFiles.length > 0) {
                    this.lockedMultiFileDelete(delFiles, vretainCounter);
                }
                return;
            }
            TransmitSvcDataUtils.logError("TsdUtils.vretainFiles called with no parms for setup", null, false);
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: HException in processing", e, false);
        }
        catch (IOException e) {
            TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: IOException in processing", e, false);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: error building, copying, or deleting zip file", e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void vretainFiles(String[] files) {
        block15: {
            if (files == null) {
                TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: no files in list", null, false);
                return;
            }
            try {
                if (this.reset) {
                    Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.vretainFiles() processing reset");
                    File[] delFiles = TransmitSvcDataUtils.getFilesList("iqysv*.zip");
                    if (delFiles != null && delFiles.length > 0) {
                        this.lockedMultiFileDelete(delFiles, vretainCounter);
                    }
                    return;
                }
                String file = files[0];
                int nameLength = file.length();
                int filenameIndex = file.lastIndexOf(File.separator);
                int dirIndex = file.substring(0, filenameIndex).lastIndexOf(File.separator);
                if (filenameIndex <= 0 || dirIndex <= 0) {
                    TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: error extracting retain number from filepath='" + file + "'", null, false);
                    return;
                }
                String vretainNum = file.substring(dirIndex + 1, filenameIndex);
                String zipFileName = "iqysv" + vretainNum + ".zip";
                String zipFilePath = BaseFileControl.getFilePath(zipFileName) + zipFileName;
                if (files.length == 1 && file.substring(nameLength - 3, nameLength).equalsIgnoreCase("zip")) {
                    Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.vretainFiles() processing setup with single zipped file");
                    Object object = tsdFileLock;
                    synchronized (object) {
                        File srcFile = new File(file);
                        File destFile = new File(zipFilePath);
                        FileUtilities.copy(srcFile, destFile);
                        if (vretainCounter.increment() > 1) {
                            Trace.trace(TRACE_MASKF, "TSD: vretainFiles(): Number of open TSD requests for " + zipFilePath + " > 1. " + "Number open=" + vretainCounter.getValue());
                        }
                        break block15;
                    }
                }
                File[] listFiles = new File[files.length];
                for (int i = 0; i < files.length; ++i) {
                    listFiles[i] = new File(files[i]);
                }
                this.lockedZipFile(listFiles, zipFilePath, vretainCounter);
            }
            catch (ClassCastException e) {
                TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: list contains non-String", e, false);
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: HException in processing", e, false);
            }
            catch (IOException e) {
                TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: IOException in processing", e, false);
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.vretainFiles: error building, copying, or deleting zip file", e, false);
            }
        }
    }

    public void licccFiles() {
        if (this.reset) {
            this.lockedDeleteFile(licccCounter, LICCC_ZIP_FILE, false);
        } else {
            try {
                File[] filelist;
                int i;
                ArrayList<File> listOfFiles = new ArrayList<File>();
                for (i = 0; i < LICCC_PATTERN.length; ++i) {
                    filelist = TransmitSvcDataUtils.getFilesList(LICCC_PATTERN[i]);
                    if (filelist == null) continue;
                    for (int j = 0; j < filelist.length; ++j) {
                        Trace.trace(TRACE_MASKF, "TsdUtils:licccFiles adding " + filelist[j]);
                        listOfFiles.add(filelist[j]);
                    }
                }
                for (i = 0; i < LICCC_FILE.length; ++i) {
                    File licccFile = new File(BaseFileControl.getFilePath(LICCC_FILE[i]) + LICCC_FILE[i]);
                    Trace.trace(TRACE_MASKF, "TsdUtils:liccc files single file=" + licccFile);
                    if (!licccFile.exists()) continue;
                    Trace.trace(TRACE_MASKF, "TsdUtils: licccFiles adding single file");
                    listOfFiles.add(licccFile);
                }
                filelist = new File[listOfFiles.size()];
                int index = 0;
                Iterator it = listOfFiles.iterator();
                while (it.hasNext()) {
                    filelist[index++] = (File)it.next();
                }
                this.lockedZipFile(filelist, LICCC_ZIP_FILE, licccCounter);
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.licccFiles: HException in processing", e, false);
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.licccFiles: Exception in processing", e, false);
            }
        }
    }

    public void lprdFiles() {
        if (this.reset) {
            File[] listFiles = new File[LPRDMP_FILES.length];
            for (int i = 0; i < listFiles.length; ++i) {
                try {
                    listFiles[i] = new File(BaseFileControl.getFilePath(LPRDMP_FILE_PATTERN) + LPRDMP_FILES[i]);
                    continue;
                }
                catch (Exception e) {
                    TransmitSvcDataUtils.logError("TsdUtils.cecdFiles: exception getting file path for delete for " + LPRDMP_FILES[i], e, false);
                    listFiles[i] = new File(LPRDMP_FILES[i]);
                }
            }
            try {
                this.lockedMultiFileDelete(listFiles, lprdmpCounter);
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.lprdFiles: HException deleting file.", e, true);
            }
            catch (IOException e) {
                TransmitSvcDataUtils.logError("TsdUtils.lprdFiles: IOException deleting file.", e, true);
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.lprdFiles: Exception deleting file.", e, true);
            }
        } else {
            TransmitSvcDataUtils.writeTrm(LPRDMP_FILES, LPRDMP_FILE_PATTERN, LPRDMP_TRM_FILE, lprdmpCounter);
        }
    }

    public void cecdFiles() {
        if (this.reset) {
            File[] listFiles = new File[CECD_FILES.length];
            for (int i = 0; i < listFiles.length; ++i) {
                try {
                    listFiles[i] = new File(BaseFileControl.getFilePath(CECD_FILE_PATTERN) + CECD_FILES[i]);
                    continue;
                }
                catch (Exception e) {
                    TransmitSvcDataUtils.logError("TsdUtils.cecdFiles: exception getting file path for delete for " + CECD_FILES[i], e, false);
                    listFiles[i] = new File(CECD_FILES[i]);
                }
            }
            try {
                this.lockedMultiFileDelete(listFiles, cecdCounter);
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.cecdFiles: HException deleting file.", e, true);
            }
            catch (IOException e) {
                TransmitSvcDataUtils.logError("TsdUtils.cecdFiles: IOException deleting file.", e, true);
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.cecdFiles: Exception deleting file.", e, true);
            }
        } else {
            TransmitSvcDataUtils.writeTrm(CECD_FILES, CECD_FILE_PATTERN, CECD_TRM_FILE, cecdCounter);
        }
    }

    public void cfdmpFiles() {
        if (this.reset) {
            File[] listFiles = new File[CFDMP_FILES.length];
            for (int i = 0; i < listFiles.length; ++i) {
                try {
                    listFiles[i] = new File(BaseFileControl.getFilePath(CFDMP_FILE_PATTERN) + CFDMP_FILES[i]);
                    continue;
                }
                catch (Exception e) {
                    TransmitSvcDataUtils.logError("TsdUtils.cecdFiles: exception getting file path for delete for " + CFDMP_FILES[i], e, false);
                    listFiles[i] = new File(CFDMP_FILES[i]);
                }
            }
            try {
                this.lockedMultiFileDelete(listFiles, cfdmpCounter);
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.cfdmpFiles: HException deleting file.", e, true);
            }
            catch (IOException e) {
                TransmitSvcDataUtils.logError("TsdUtils.cfdmpFiles: IOException deleting file.", e, true);
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.cfdmpFiles: Exception deleting file.", e, true);
            }
        } else {
            TransmitSvcDataUtils.writeTrm(CFDMP_FILES, CFDMP_FILE_PATTERN, CFDMP_TRM_FILE, cfdmpCounter);
        }
    }

    public void cduFiles() {
        if (this.reset) {
            this.lockedDeleteFile(cudCounter, CUD_ZIP_FILE, false);
        } else {
            this.lockedZipFilePattern("cduffdc_*", "cduffdc_*", CUD_ZIP_FILE, cudCounter);
        }
    }

    public void cksFiles() {
        if (this.reset) {
            this.lockedDeleteFile(cksCounter, CKS_ZIP_FILE, false);
        } else {
            this.lockedZipFilePattern(CKS_FILE_PATTERN, CKS_FILE_PATH_PATTERN, CKS_ZIP_FILE, cksCounter);
        }
    }

    public void actpFiles() {
        if (this.reset) {
            this.lockedDeleteFile(actpCounter, ACTP_ZIP_FILE, false);
        } else {
            this.lockedZipFilePattern(ACTP_FILE_PATTERN, ACTP_FILE_PATH_PATTERN, ACTP_ZIP_FILE, actpCounter);
        }
    }

    public void lparzFiles() {
        if (this.reset) {
            this.lockedDeleteFile(lparzCounter, LPARZ_ZIP_FILE, false);
        } else {
            this.lockedZipFilePattern(LPARZ_FILE_PATTERN, LPARZ_FILE_PATH_PATTERN, LPARZ_ZIP_FILE, lparzCounter);
        }
    }

    public void iocdsFiles(String[] files) {
        if (files == null) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: no files in list", null, false);
            return;
        }
        try {
            if (this.reset) {
                Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.vretainFiles() processing reset");
                this.lockedFileOp(iocdsCounter, "", "iqysiocd.zip", true);
                Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::iocdsFiles()");
                return;
            }
            String zipFilePath = BaseFileControl.getFilePath("iqysiocd.zip") + "iqysiocd.zip";
            File[] listFiles = new File[files.length];
            for (int i = 0; i < files.length; ++i) {
                listFiles[i] = new File(files[i]);
            }
            this.lockedZipFile(listFiles, zipFilePath, iocdsCounter);
        }
        catch (ClassCastException e) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: list contains non-String", e, false);
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: HException in processing", e, false);
        }
        catch (IOException e) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: IOException in processing", e, false);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: error building, copying, or deleting zip file", e, false);
        }
    }

    public void iocdsFiles() {
        try {
            if (this.reset) {
                Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.vretainFiles() processing reset");
                this.lockedFileOp(iocdsCounter, "", "iqysiocd.zip", true);
                Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::iocdsFiles()");
                return;
            }
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles called with no parms for setup", null, false);
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: HException in processing", e, false);
        }
        catch (IOException e) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: IOException in processing", e, false);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.iocdsFiles: error building, copying, or deleting zip file", e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allCompLogs() {
        block12: {
            Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::allCompLogs()");
            try {
                if (this.reset) break block12;
                File[] filesArray = TransmitSvcDataUtils.getFilesList("iqyycom?.log");
                if (filesArray != null) {
                    if (filesArray.length > 0) {
                        String trmFilepath = BaseFileControl.getFilePath("iqyscomp.trm");
                        if (trmFilepath == null) break block12;
                        Object object = tsdFileLock;
                        synchronized (object) {
                            File trmFile = new File(trmFilepath + "iqyscomp.trm");
                            try {
                                FileWriter fw = TransmitSvcDataUtils.write_first_line(trmFilepath + "iqyscomp.trm", filesArray[0].getPath() + "\n");
                                for (int i = 1; i < filesArray.length; ++i) {
                                    TransmitSvcDataUtils.append_line(fw, filesArray[i].getPath() + "\n");
                                }
                                try {
                                    fw.flush();
                                    fw.close();
                                }
                                catch (IOException e) {
                                    Trace.trace(TRACE_MASKF, "TsdUtils.allCompLogs: error flushing or closing iqyscomp.trm");
                                    Trace.trace(TRACE_MASKF, e);
                                }
                            }
                            catch (IOException e) {
                                TransmitSvcDataUtils.logError("TSDUtils.allCompLogs: error writing to " + trmFilepath + "iqyscomp.trm", e, false);
                            }
                            break block12;
                        }
                    }
                    HException h = new HException("No compressed log files found");
                    TransmitSvcDataUtils.logError("TSDUtils.allCompLogs: No compressed log files found", h, false);
                    break block12;
                }
                HException h = new HException("Compressed log file array is null");
                TransmitSvcDataUtils.logError("TSDUtils.allCompLogs: Compressed log file array is null", h, false);
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.allCompLogs: error getting list of compressed logs or file path for iqyscomp.trm", e, false);
            }
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::allCompLogs()");
    }

    public void unitData() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::unitData()");
        try {
            this.lockedFileOp(acuscudCounter, "actwcud.dat", "acuscud.dat", true);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.unitData: error copying file", e, false);
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::unitData()");
    }

    public void peData() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::peData()");
        if (!this.reset) {
            Trace.trace(TRACE_MASKF, " PE Data: Filename =  " + this._miscDataArray[0] + " Pattern =  " + this._miscDataArray[1]);
            try {
                this.createZipFile(this._miscDataArray[0], this._miscDataArray[1]);
            }
            catch (IOException e) {
                TransmitSvcDataUtils.logError("processLogFile: IOException thrown creating zip file", e, false);
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("processLogFile: exception creating zip file", e, false);
            }
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::peData()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logSummary() {
        block44: {
            Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::logSummary()");
            if (!this.reset) {
                try {
                    Object object = tsdFileLock;
                    synchronized (object) {
                        TransmitSvcDataUtils.htsi_proc_sysref();
                    }
                    if (HMC) {
                        Trace.trace(TRACE_MASKD, " processing for msg 17");
                        long recLength = TransmitSvcDataUtils.getFileLength("iqyvpd.dat");
                        String header = "HMCHDR 129 " + nf5.format(recLength) + " " + TransmitSvcDataUtils.buildVpdDate() + blanks100.substring(0, 94) + "#\r\n";
                        Object object2 = tsdFileLock;
                        synchronized (object2) {
                            TransmitSvcDataUtils.prependHeader("iqyvpd.dat", "iqysvpd.dat", header);
                            if (iqysvpdCounter.increment() > 1) {
                                Trace.trace(TRACE_MASKF, "TsdUtils: logSummary: Number of open TSD requests for iqysvpd > 1. Number open=" + iqysvpdCounter.getValue());
                            }
                            break block44;
                        }
                    }
                    if (!SE) break block44;
                    Object recLength = tsdFileLock;
                    synchronized (recLength) {
                        TransmitSvcDataUtils.saveTsadData(this.TSAD);
                        TransmitSvcDataUtils.getTsadHMCSerials();
                        if (sadCounter.increment() > 1) {
                            Trace.trace(TRACE_MASKF, "TsdUtils: logSummary: Number of open TSD requests for acusevt > 1. Number open=" + sadCounter.getValue());
                        }
                    }
                }
                catch (HException e) {
                    TransmitSvcDataUtils.logError("TsdUtils.logSummary error creating log summary", e, true);
                }
            } else {
                if (HMC) {
                    boolean deleted = true;
                    Object object = tsdFileLock;
                    synchronized (object) {
                        if (iqysvpdCounter.decrement() < 1) {
                            deleted = TransmitSvcDataUtils.xdfc_file_delete("iqysvpd.dat", true);
                        }
                    }
                    if (!deleted) {
                        Trace.trace(TRACE_MASKF, "TsdUtils: logSummary: Unable to delete iqysvpd.dat");
                    }
                }
                if (this.satisfactoryCompletion && this.tsdRequest != null) {
                    TransmitDataRequestBody tsdReqBody;
                    if (HMC) {
                        Object object = tsdFileLock;
                        synchronized (object) {
                            try {
                                tsdReqBody = (TransmitDataRequestBody)this.tsdRequest.getBody();
                                String pssBit = tsdReqBody.getAttribute("TSAD");
                                if (pssBit != null && pssBit.equals("1") && iqysvpdCounter.getValue() < 1 && TransmitSvcDataUtils.xdfc_file_delete("acusevt.trm", true)) {
                                    String evtPath = BaseFileControl.getFilePath("acusevt.trm");
                                    FileWriter fw = TransmitSvcDataUtils.write_first_line(evtPath + "acusevt.trm", "acusref.dat");
                                    try {
                                        fw.flush();
                                        fw.close();
                                    }
                                    catch (IOException e) {
                                        Trace.trace(TRACE_MASKF, "TsdUtils.logSummary: error flushing or closing acusevt.trm");
                                        Trace.trace(TRACE_MASKF, e);
                                    }
                                }
                            }
                            catch (IOException e) {
                                TransmitSvcDataUtils.logError("TsdUtils.logSummary on completion: error rewriting acusevt.trm", e, true);
                            }
                            catch (HException h) {
                                TransmitSvcDataUtils.logError("TsdUtils.logSummary on completion: error getting file path for acusevt.trm", h, true);
                            }
                            catch (Exception e) {
                                TransmitSvcDataUtils.logError("TsdUtils.logSummary on completion: error getting TransmitDataRequestBody", e, true);
                            }
                        }
                    }
                    if (SE) {
                        Object object = tsdFileLock;
                        synchronized (object) {
                            String pssBit;
                            if (sadCounter.decrement() < 1 && (pssBit = (tsdReqBody = (TransmitDataRequestBody)this.tsdRequest.getBody()).getAttribute("TSAD")) != null && pssBit.equals("1")) {
                                TransmitSvcDataUtils.rewriteTsadFile();
                            }
                        }
                    }
                } else if (SE) {
                    Object object = tsdFileLock;
                    synchronized (object) {
                        sadCounter.decrement();
                    }
                }
            }
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::logSummary()");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void mcfTraces() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::mcfTraces()");
        int i = 0;
        try {
            if (!this.reset) {
                String traPath = BaseFileControl.getFilePath("iqzmcf00.tra");
                String filePath = BaseFileControl.getFilePath("acusmcf.trm");
                FileWriter fw = TransmitSvcDataUtils.write_first_line(filePath + "acusmcf.trm", traPath + "iqzmcf00.tra" + "\n");
                for (i = 1; i <= 16; ++i) {
                    TransmitSvcDataUtils.append_line(fw, traPath + "iqzmcf" + nf2.format(i) + ".tra" + "\n");
                }
                try {
                    fw.flush();
                    fw.close();
                }
                catch (IOException e) {
                    Trace.trace(TRACE_MASKF, "TsdUtils.mcfTraces() exception flushing or closing acusmscf.trm");
                    Trace.trace(TRACE_MASKF, e);
                }
            } else {
                boolean deleted = true;
                deleted = TransmitSvcDataUtils.xdfc_file_delete("acusmcf.trm", true);
                if (!deleted) {
                    Trace.trace(TRACE_MASKF, "TsdUtils.mcfTraces() unable to delete acusmcf.trm");
                }
                if (!this.satisfactoryCompletion) {
                    // empty if block
                }
            }
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TsdUtils.mcfTraces: error getting filepath for acusmcf.trm", e, false);
        }
        catch (IOException e) {
            TransmitSvcDataUtils.logError("TsdUtils.mcfTraces: error writing to acusmcf.trm", e, false);
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::mcfTraces()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockedFileOp(FileCounter counter, String sourceFilename, String targetFilename, boolean needTargetPath) throws HException, FileNotFoundException, IOException {
        if (!this.reset) {
            Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.lockedFileOp() processing setup");
            Object object = tsdFileLock;
            synchronized (object) {
                TransmitSvcDataUtils.xdfc_file_copy(sourceFilename, targetFilename);
                if (counter.increment() > 1) {
                    Trace.trace(TRACE_MASKF, "TSD: lockedFileOp(): Number of open TSD requests for " + targetFilename + " > 1. " + "Number open=" + counter.getValue());
                }
            }
        }
        Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.lockedFileOp() processing reset");
        Object object = tsdFileLock;
        synchronized (object) {
            if (counter.decrement() < 1) {
                TransmitSvcDataUtils.xdfc_file_delete(targetFilename, needTargetPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lockedDeleteFile(FileCounter counter, String filename, boolean needPath) {
        Trace.trace(TRACE_MASKF, "->TransmitSvcDataUtils.lockedDeleteFile()");
        try {
            Object object = tsdFileLock;
            synchronized (object) {
                if (counter.decrement() < 1) {
                    TransmitSvcDataUtils.xdfc_file_delete(filename, needPath);
                }
            }
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.lockedDeleteFile: Exception deleting file " + filename, e, true);
        }
    }

    protected static void xdfc_file_copy(String srcFileName, String destFileName) throws HException {
        Trace.trace(TRACE_MASKT, "-> xdfc_file_copy: ");
        Trace.trace(TRACE_MASKD, "src = [" + srcFileName + "], dest = [" + destFileName + "]");
        String srcPath = null;
        String destPath = null;
        try {
            srcPath = BaseFileControl.getFilePath(srcFileName);
            destPath = BaseFileControl.getFilePath(destFileName);
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TSD.xdfc_file_copy:error getting filePath for " + srcFileName + " or " + destFileName, e, false);
            throw e;
        }
        Trace.trace(TRACE_MASKF, "xdfc_file_copy: srcPath = " + srcPath);
        File srcFile = new File(srcPath + srcFileName);
        File destFile = new File(destPath + destFileName);
        try {
            FileUtilities.copy(srcFile, destFile);
        }
        catch (FileNotFoundException e) {
            HException h = new HException(e);
            TransmitSvcDataUtils.logError("TSD.xdfc_file_copy: " + srcPath + srcFileName + " does NOT exist", h, false);
            throw h;
        }
        catch (IOException e) {
            HException h = new HException(e);
            TransmitSvcDataUtils.logError("TSD.xdfc_file_copy: IOException copying file", h, false);
            throw h;
        }
        Trace.trace(TRACE_MASKT, "<- xdfc_file_copy: ");
    }

    protected static boolean xdfc_file_delete(String delFileName, boolean needDelFileName) {
        Trace.trace(TRACE_MASKF, "-> TSD.xdfc_file_delete: delfile = [" + delFileName + "]");
        try {
            boolean deleted;
            String delPath = "";
            File delFile = null;
            if (needDelFileName) {
                delPath = BaseFileControl.getFilePath(delFileName);
                Trace.trace(TRACE_MASKF, "xdfc_file_delete: delPath = " + delPath);
            }
            if (!(deleted = (delFile = new File(delPath + delFileName)).delete())) {
                Trace.trace(TRACE_MASKF, "xdfc_file_delete: " + delPath + delFileName + " does NOT exist");
            }
            Trace.trace(TRACE_MASKT, "<- TSD.xdfc_file_delete: ");
            return deleted;
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TsdUtils.xdfc_file_delete: Error getting file path for [" + delFileName + "]", e, false);
            return false;
        }
    }

    protected static ArrayList readTrm(String trmFilename) {
        BufferedReader in;
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::readTrm() " + trmFilename);
        File listFile = new File(trmFilename);
        try {
            in = new BufferedReader(new FileReader(listFile));
        }
        catch (FileNotFoundException e) {
            TransmitSvcDataUtils.logError("TsdUtils.readTrm: multi-filelist file '" + trmFilename + "' not found.", e, false);
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String fileName = null;
        do {
            try {
                fileName = in.readLine();
                if (fileName == null || fileName.length() <= 1 || fileName.substring(0, 2).equals("/*")) continue;
                Trace.trace(TRACE_MASKD, "TsdUtils.readTrm found = [" + fileName + "]");
                list.add(fileName);
            }
            catch (IOException e) {
                TransmitSvcDataUtils.logError("TsdUtils.readTrm: error reading trm file '" + trmFilename + "'.", e, false);
            }
        } while (fileName != null);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeTrm(String[] lines, String filePathPattern, String filename, FileCounter counter) {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::writeTrm() " + filename);
        if (lines == null || lines.length < 1) {
            Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::writeTrm() no lines to write");
            return;
        }
        Object object = tsdFileLock;
        synchronized (object) {
            try {
                String filePath = filePathPattern != null ? BaseFileControl.getFilePath(filePathPattern) + lines[0] : lines[0];
                FileWriter fw = TransmitSvcDataUtils.write_first_line(filename, filePath + "\n");
                for (int i = 1; i < lines.length; ++i) {
                    filePath = filePathPattern != null ? BaseFileControl.getFilePath(filePathPattern) + lines[i] : lines[i];
                    TransmitSvcDataUtils.append_line(fw, filePath + "\n");
                }
                try {
                    fw.flush();
                    fw.close();
                }
                catch (Exception e) {
                    Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils:writeTrm: exception on flush and close for " + filename);
                }
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.writeTrm: HException writing file [" + filename + "]", e, false);
            }
            catch (IOException e) {
                TransmitSvcDataUtils.logError("TsdUtils.writeTrm: IOException writing file " + filename, e, false);
            }
            catch (Exception e) {
                TransmitSvcDataUtils.logError("TsdUtils.writeTrm: Exception writing file " + filename, e, false);
            }
            if (counter != null && counter.increment() > 1) {
                Trace.trace(TRACE_MASKF, "TSD: writeTrm(): Number of open TSD requests for " + filename + " > 1. " + "Number open=" + counter.getValue());
            }
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::writeTrm()");
    }

    protected static FileWriter write_first_line(String file_name, String file_entry) throws IOException {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils.write_first_line: filename=[" + file_name + "]");
        new File(file_name).delete();
        FileWriter fw = new FileWriter(file_name, true);
        fw.write(file_entry);
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils.write_first_line");
        return fw;
    }

    protected static void append_line(FileWriter fw, String file_entry) throws IOException {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils.append_line: line=[" + file_entry + "]");
        fw.write(file_entry);
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils.append_line");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createZipFile(String filename, String pattern) throws IOException, HException {
        File[] listFiles = TransmitSvcDataUtils.getFilesList(pattern);
        Object object = tsdFileLock;
        synchronized (object) {
            this.zipFile(listFiles, filename);
        }
    }

    protected void lockedZipFilePattern(String filePattern, String filePathPattern, String zipFile, FileCounter counter) {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::lockedZipFilePattern() for zip file " + zipFile);
        try {
            File[] filesToZip = TransmitSvcDataUtils.getFilesList(filePattern, filePathPattern);
            this.lockedZipFile(filesToZip, zipFile, counter);
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TsdUtils.lockedZipFilePattern: Error getting file path for [" + filePathPattern + "]", e, false);
        }
        catch (IOException e) {
            TransmitSvcDataUtils.logError("TsdUtils.lockedZipFilePattern: IOException getting or zipping files for " + filePattern, e, false);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.lockedZipFilePattern: Exception getting or zipping files for " + filePattern, e, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockedZipFile(File[] listFiles, String zipFileName, FileCounter counter) throws IOException, HException {
        if (!this.reset) {
            Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.lockedZipFile() processing setup");
            Object object = tsdFileLock;
            synchronized (object) {
                this.zipFile(listFiles, zipFileName);
                if (counter.increment() > 1) {
                    Trace.trace(TRACE_MASKF, "TSD: lockedZipFile(): Number of open TSD requests for " + zipFileName + " > 1. " + "Number open=" + counter.getValue());
                }
            }
        }
        Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.lockedZipFile() processing reset");
        Object object = tsdFileLock;
        synchronized (object) {
            if (counter.decrement() < 1) {
                TransmitSvcDataUtils.xdfc_file_delete(zipFileName, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void lockedMultiFileDelete(File[] listFiles, FileCounter counter) throws IOException, HException {
        Trace.trace(TRACE_MASKF, "TransmitSvcDataUtils.lockedMultiFileDelete");
        if (!this.reset) {
            TransmitSvcDataUtils.logError("TransmitSvcDataUtils.lockedMultiFileDelete only valid for reset", null, false);
            return;
        }
        if (listFiles == null) {
            TransmitSvcDataUtils.logError("TransmitSvcDataUtils.lockedMultiFileDelete - file list null", null, false);
            return;
        }
        Object object = tsdFileLock;
        synchronized (object) {
            if (counter.decrement() < 1) {
                for (int i = 0; i < listFiles.length; ++i) {
                    listFiles[i].delete();
                }
            }
        }
    }

    protected void zipFile(File[] listFiles, String zipFileName) throws IOException, HException {
        ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(new File(zipFileName)));
        byte[] buf = new byte[10240];
        for (int i = 0; i < listFiles.length; ++i) {
            Trace.trace(TRACE_MASKD, " Processing file =  " + listFiles[i]);
            ZipEntry zipentry = new ZipEntry(listFiles[i].getName());
            zipout.putNextEntry(zipentry);
            FileInputStream instr = new FileInputStream(listFiles[i].getAbsolutePath());
            while (true) {
                int len = instr.read(buf);
                Trace.trace(TRACE_MASKD, " PE Data: bytes read =  " + len);
                if (len < 0) break;
                zipout.write(buf, 0, len);
                zipout.flush();
            }
            zipout.closeEntry();
        }
        zipout.finish();
    }

    protected static File[] getFilesList(String pattern) throws HException {
        return TransmitSvcDataUtils.getFilesList(pattern, pattern);
    }

    /*
     * WARNING - void declaration
     */
    protected static File[] getFilesList(String pattern, String fileControlPattern) throws HException {
        void var4_4;
        void var3_3;
        String maskString;
        String dirPath;
        Trace.trace(TRACE_MASKT, "-> TsdUtils::getFilesList() pattern=" + pattern);
        int fileCharIndex = pattern.lastIndexOf(File.separatorChar);
        if (fileCharIndex >= 0) {
            dirPath = pattern.substring(0, fileCharIndex + 1);
            maskString = pattern.substring(fileCharIndex + 1);
        } else {
            try {
                dirPath = BaseFileControl.getFilePath(fileControlPattern);
                Trace.trace(TRACE_MASKF, "TsdUtils.getFilesList in " + dirPath);
                maskString = pattern;
            }
            catch (HException e) {
                TransmitSvcDataUtils.logError("TsdUtils.getFilesList: error getting file path for '" + pattern + "'.", e, false);
                throw e;
            }
        }
        File comFile = new File((String)var3_3);
        GlobFilenameFilter filter = new GlobFilenameFilter((String)var4_4, true);
        Trace.trace(TRACE_MASKF, "getFilesList: dirPath=" + (String)var3_3 + " maskString=" + (String)var4_4);
        return comFile.listFiles(filter);
    }

    public static boolean htsi_proc_sysref() throws HException {
        String file_name;
        Trace.trace(TRACE_MASKT, "<> TransmitSvcUtils.htsi_proc_sysref ");
        try {
            String refPath = BaseFileControl.getFilePath("acusref.dat");
            file_name = refPath + "acusref.dat";
        }
        catch (HException h) {
            TransmitSvcDataUtils.logError("TsdUtils.htsi_proc_sysref: error getting filepath for acusref.dat", h, false);
            throw h;
        }
        Trace.trace(TRACE_MASKD, "TsdUtils.htsi_proc_sysref: filepath =" + file_name);
        byte[] version = new byte[]{1, 0};
        Date oldDate = null;
        try {
            FileInputStream inputFile = new FileInputStream(file_name);
            byte[] buffer = new byte[10];
            int bytesRead = ((InputStream)inputFile).read(buffer);
            if (bytesRead == 10) {
                version[0] = buffer[0];
                version[1] = buffer[1];
                Date readDate = TransmitSvcDataUtils.getDate(buffer, 2);
                if (readDate != null) {
                    oldDate = readDate;
                    Trace.trace(TRACE_MASKF, "TsdUtils.htsi_proc_sysref: old date =" + oldDate + "(" + TransmitSvcDataUtils.buildLogDate(oldDate) + ")");
                }
            } else {
                Trace.trace(TRACE_MASKF, "TsdUtils.htsi_proc_sysref: no date found in file");
            }
            ((InputStream)inputFile).close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.htsi_proc_sysref: unable to read file for date");
        }
        Date newDate = new Date();
        byte[] dateString = TransmitSvcDataUtils.setDate(newDate);
        Trace.trace(TRACE_MASKD, "TsdUtils.htsi_proc_sysref new date=" + newDate + "(" + TransmitSvcDataUtils.buildLogDate(newDate) + ")");
        try {
            Log[] logEntries = Log.retrieve(null, null, null, oldDate, null, null, null, null);
            Trace.trace(TRACE_MASKF, "logEntries.length = " + logEntries.length);
            FileOutputStream output = new FileOutputStream(file_name);
            BufferedOutputStream bufferedOutput = new BufferedOutputStream(output, 8192);
            bufferedOutput.write(version);
            bufferedOutput.write(dateString);
            Short logUser = null;
            Date logTimestamp = null;
            for (int i = logEntries.length - 1; i >= 0; --i) {
                String logDataStr;
                String logClassStr = HexString.toHex(logEntries[i].getLogClass(), true).toUpperCase();
                String logTypeStr = HexString.toHex(logEntries[i].getLogType(), true).toUpperCase();
                logUser = new Short(logEntries[i].getUser());
                String logUserStr = HexString.toHex(logUser, true).toUpperCase();
                String logEventIdStr = logClassStr + logTypeStr + logUserStr;
                Trace.trace(TRACE_MASKD, "Tsd:htsi_proc_sysref logEntry " + i + " " + logEventIdStr);
                logTimestamp = logEntries[i].getTimestamp();
                String logEventNameStr = logEntries[i].getEventName();
                int eventNameLength = logEventNameStr.length();
                if (eventNameLength > 12) {
                    logEventNameStr = logEventNameStr.substring(0, 12);
                } else if (eventNameLength < 12) {
                    logEventNameStr = logEventNameStr + blanks12.substring(0, 12 - eventNameLength);
                }
                String towerData = logEntries[i].getTowerData();
                if (towerData == null) {
                    Trace.trace(TRACE_MASKF, "Tsd:htsi_proc_sysref towerData=null for logEntry " + i + ". Skipping.");
                    logDataStr = "        " + nullByte + "        " + nullByte + "  ";
                } else {
                    logDataStr = TransmitSvcDataUtils.formatTowerData(logEntries[i].getTowerData());
                }
                String type_log = logEntries[i].isError() ? "E" : "I";
                String htsi_refcode_data = logEventIdStr + nullByte + TransmitSvcDataUtils.buildLogDate(logTimestamp) + nullByte + type_log + nullByte + logEventNameStr + nullByte + logDataStr + nullByte;
                Trace.trace(TRACE_MASKD, "TsdUtils.htsi_proc_sysref: For logEntry #" + i + " entry='" + htsi_refcode_data + "'");
                bufferedOutput.write(htsi_refcode_data.getBytes());
            }
            try {
                bufferedOutput.flush();
                bufferedOutput.close();
                ((OutputStream)output).close();
            }
            catch (IOException e) {
                Trace.trace(TRACE_MASKF, "TsdUtils.htsi_proc_sysref: Error flushing or closing acusref.dat");
                Trace.trace(TRACE_MASKF, e);
            }
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.htsi_proc_sysref: exception");
            Trace.trace(TRACE_MASKF, e);
            HException h = new HException(e);
            TransmitSvcDataUtils.logError("TsdUtils.htsi_proc_sysref: IOException writing acusref.dat", h, false);
            throw h;
        }
        return true;
    }

    private static void saveTsadData(boolean tsad) {
        String command = "iqzqtsa2";
        String filename = "iqzqtsad.trm";
        if (!tsad) {
            command = "iqzqtsa1";
            filename = "iqzqfedc.trm";
        }
        try {
            NativeProcess np = NativeProcess.exec(new NativeProcessParameters(command));
            Trace.trace(TRACE_MASKD, "TsdUtils.saveTsadData: waiting");
            np.waitFor();
            Trace.trace(TRACE_MASKF, "TsdUtils.saveTsadData: done waitng");
            int rc = np.exitValue();
            Trace.trace(TRACE_MASKF, "TsdUtils.saveTsadData: rc=" + rc);
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.saveTsadData: error executing native process for save tsad data", e, false);
        }
        try {
            TransmitSvcDataUtils.xdfc_file_copy(filename, "iqzqtsad.dat");
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.saveTsadData: error copying save tsad file, " + filename, e, false);
        }
    }

    private static void getTsadHMCSerials() {
    }

    private static void rewriteTsadFile() {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcDataUtils::rewriteTsadFile()");
        String filename = "acusevt.trm";
        try {
            filename = BaseFileControl.getFilePath(filename) + filename;
        }
        catch (HException e) {
            TransmitSvcDataUtils.logError("TsdUtils.rewriteTsadFile: can't get filepath for acusevt.trm", e, false);
            return;
        }
        ArrayList filelist = TransmitSvcDataUtils.readTrm(filename);
        String removeFile = "BBRUCFG.DAT";
        ArrayList<String> newList = new ArrayList<String>();
        String[] sample = new String[1];
        Iterator files = filelist.iterator();
        while (files.hasNext()) {
            String file = (String)files.next();
            if (file.endsWith(removeFile)) continue;
            newList.add(file);
        }
        TransmitSvcDataUtils.writeTrm(newList.toArray(sample), null, filename, null);
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::rewriteTsadFile()");
    }

    public static boolean checkFilePattern(String pattern) {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcUtils.checkFilePattern: pattern = " + pattern);
        try {
            File[] files = TransmitSvcDataUtils.getFilesList(pattern);
            Trace.trace(TRACE_MASKF, "<-TsdUtils.checkFilePattern: number of files = " + files.length);
            return files.length > 0;
        }
        catch (Exception e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.checkFilePattern: Exception thrown");
            Trace.trace(TRACE_MASKF, e);
            return false;
        }
    }

    public static Date getDate(byte[] todStruct, int offset) {
        if (todStruct.length - offset < 8) {
            return null;
        }
        Trace.trace(TRACE_MASKD, "get date=" + HexString.toHex(todStruct));
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar oldCal = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        oldCal.set(1, (TransmitSvcDataUtils.getByteNum(todStruct[offset]) << 8) + TransmitSvcDataUtils.getByteNum(todStruct[offset + 1]));
        oldCal.set(2, TransmitSvcDataUtils.getByteNum(todStruct[offset + 2]));
        oldCal.set(5, TransmitSvcDataUtils.getByteNum(todStruct[offset + 3]));
        oldCal.set(11, TransmitSvcDataUtils.getByteNum(todStruct[offset + 4]));
        oldCal.set(12, TransmitSvcDataUtils.getByteNum(todStruct[offset + 5]));
        oldCal.set(13, TransmitSvcDataUtils.getByteNum(todStruct[offset + 6]));
        oldCal.set(14, TransmitSvcDataUtils.getByteNum(todStruct[offset + 7]) * 10);
        return oldCal.getTime();
    }

    public static byte[] setDate(Date date) {
        int andNum = 255;
        int orNum = -256;
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar cal = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        cal.setTime(date);
        byte[] tod = new byte[8];
        int val = cal.get(1);
        tod[0] = (byte)(val >> 8);
        tod[1] = (val & andNum) > 127 ? (byte)(val | orNum) : (byte)(val & andNum);
        tod[2] = (byte)cal.get(2);
        tod[3] = (byte)cal.get(5);
        tod[4] = (byte)cal.get(11);
        tod[5] = (byte)cal.get(12);
        tod[6] = (byte)cal.get(13);
        tod[7] = (byte)(cal.get(14) / 10);
        Trace.trace(TRACE_MASKD, "set date=" + HexString.toHex(tod));
        return tod;
    }

    public static String formatHtsiDate(Date date) {
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar cal = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        cal.setTime(date);
        String year = nf4.format(cal.get(1));
        return nf2.format(cal.get(2)) + "-" + nf2.format(cal.get(5)) + "-" + year.substring(2);
    }

    public static String formatHtsiTime(Date date) {
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar cal = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        cal.setTime(date);
        return nf2.format(cal.get(11)) + ":" + nf2.format(cal.get(12)) + ":" + nf2.format(cal.get(13)) + ":" + nf2.format(cal.get(14) / 10);
    }

    public static int getByteNum(byte num) {
        int andByte = 127;
        int ans = num < 0 ? num & andByte + 128 : num;
        Trace.trace(TRACE_MASKD, "Tsd getByteNum " + HexString.toHex((byte)num) + "=" + ans);
        return ans;
    }

    public static void append(File file1, File file2) throws FileNotFoundException, IOException {
        FileInputStream file1Input = new FileInputStream(file1);
        BufferedInputStream bufFile1Input = new BufferedInputStream(file1Input, 8192);
        FileOutputStream file2Output = new FileOutputStream(file2, true);
        BufferedOutputStream bufFile2Output = new BufferedOutputStream(file2Output, 8192);
        byte[] buffer = new byte[8192];
        int bytesRead = bufFile1Input.read(buffer);
        while (bytesRead != -1) {
            bufFile2Output.write(buffer, 0, bytesRead);
            bytesRead = bufFile1Input.read(buffer);
        }
        try {
            bufFile1Input.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.append: Exception on input stream close");
            Trace.trace(TRACE_MASKF, e);
        }
        try {
            bufFile2Output.flush();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.append: Exception on output stream flush");
            Trace.trace(TRACE_MASKF, e);
        }
        try {
            bufFile2Output.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.append: Exception on output stream close");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public static void append(File inputFile, BufferedOutputStream bufFileOutput) throws FileNotFoundException, IOException {
        FileInputStream fileInput = new FileInputStream(inputFile);
        BufferedInputStream bufFileInput = new BufferedInputStream(fileInput, 8192);
        byte[] buffer = new byte[8192];
        int bytesRead = bufFileInput.read(buffer);
        while (bytesRead != -1) {
            bufFileOutput.write(buffer, 0, bytesRead);
            bytesRead = bufFileInput.read(buffer);
        }
        try {
            bufFileInput.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.append: Exception on input stream close");
            Trace.trace(TRACE_MASKF, e);
        }
        try {
            bufFileOutput.flush();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.append: Exception on output stream flush");
            Trace.trace(TRACE_MASKF, e);
        }
        try {
            bufFileOutput.close();
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "TsdUtils.append: Exception on output stream close");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public static void prependHeader(String srcFilename, String targetFilename, String line) throws HException {
        Trace.trace(TRACE_MASKT, "-> TransmitSvcUtils.prependHeader");
        String refPath = BaseFileControl.getFilePath(targetFilename);
        File destFile = new File(refPath + targetFilename);
        refPath = BaseFileControl.getFilePath(srcFilename);
        File srcFile = new File(refPath + srcFilename);
        if (!srcFile.exists()) {
            HException h = new HException("No source file for: " + refPath + srcFilename);
            TransmitSvcDataUtils.logError("TransmitSvcDataUtils.prependHeader: " + refPath + srcFilename + " does NOT exist", h, false);
            throw h;
        }
        try {
            BufferedOutputStream bufFileOutput = new BufferedOutputStream(new FileOutputStream(destFile), 8192);
            bufFileOutput.write(line.getBytes());
            TransmitSvcDataUtils.append(srcFile, bufFileOutput);
        }
        catch (FileNotFoundException e) {
            HException h = new HException("File not found for output: " + destFile);
            TransmitSvcDataUtils.logError("TransmitSvcDataUtils.prependHeader: FileNotFoundException thrown for: " + destFile, h, false);
            throw h;
        }
        catch (IOException e) {
            HException h = new HException("Error writing to file '" + destFile + "'");
            TransmitSvcDataUtils.logError("TransmitSvcDataUtils:prependHeader: Error writing to file " + destFile, h, false);
            throw h;
        }
        Trace.trace(TRACE_MASKT, "<- TransmitSvcDataUtils::prependHeader()");
    }

    private static String buildVpdDate() {
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar date = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        StringBuffer buffer = new StringBuffer();
        buffer.append(nf4.format(date.get(1)));
        buffer.append(nf2.format(date.get(2)));
        buffer.append(nf2.format(date.get(5)));
        buffer.append(nf2.format(date.get(11)));
        buffer.append(nf2.format(date.get(12)));
        buffer.append(nf2.format(date.get(13)));
        buffer.append(" ");
        return buffer.toString();
    }

    private static String buildLogDate(Date inDate) {
        if (inDate == null || inDate.getTime() == 0L) {
            return "00-00-00 00:00:00:00";
        }
        UserContext userContext = UserContext.getCurrentUserContext();
        Calendar date = Calendar.getInstance(userContext.getTimeZone(), userContext.getLocale());
        date.setTime(inDate);
        StringBuffer buffer = new StringBuffer();
        buffer.append(nf2.format(date.get(2) + 1));
        buffer.append("-");
        buffer.append(nf2.format(date.get(5)));
        buffer.append("-");
        buffer.append(nf4.format(date.get(1)).substring(2));
        buffer.append(nullByte);
        buffer.append(nf2.format(date.get(11)));
        buffer.append(":");
        buffer.append(nf2.format(date.get(12)));
        buffer.append(":");
        buffer.append(nf2.format(date.get(13)));
        buffer.append(":");
        buffer.append(nf2.format(date.get(14) / 10));
        return buffer.toString();
    }

    public static long getFileLength(String filename) throws HException {
        Trace.trace(TRACE_MASKT, "<> TransmitSvcUtils.getFileLength");
        String refPath = BaseFileControl.getFilePath(filename);
        File file = new File(refPath + filename);
        return file.length();
    }

    private static void logError(String msg, Throwable t, boolean infoOnly) {
        Trace.trace(TRACE_MASKF, msg);
        if (t != null) {
            Trace.trace(TRACE_MASKF, t);
        }
        FrameworkLog errLog = t != null ? new FrameworkLog(logInfo, 20592, t) : new FrameworkLog(logInfo, 20592);
        errLog.add(msg);
        if (infoOnly) {
            errLog.log(infoLog);
        } else {
            errLog.log();
        }
    }

    private static String formatTowerData(String towerData) {
        String refcode = "        ";
        String refcodeext = "        ";
        String statusBytes = "  ";
        StringTokenizer tokens = new StringTokenizer(towerData);
        if (tokens.hasMoreTokens()) {
            String temp = tokens.nextToken();
            refcode = temp.length() < 8 ? temp + refcode.substring(0, 8 - temp.length()) : temp.substring(0, 8);
            if (tokens.hasMoreTokens()) {
                temp = tokens.nextToken();
                refcodeext = temp.length() < 8 ? temp + refcodeext.substring(0, 8 - temp.length()) : temp.substring(0, 8);
                if (tokens.hasMoreTokens()) {
                    temp = tokens.nextToken();
                    statusBytes = temp.length() == 1 ? temp + " " : temp.substring(0, 2);
                }
            }
        }
        return refcode + nullByte + refcodeext + nullByte + statusBytes;
    }

    private static String fixLengthStringNullPad(String initString, int length) {
        if (initString.length() == length) {
            return initString;
        }
        StringBuffer buffer = new StringBuffer(initString);
        buffer.setLength(length);
        return buffer.toString();
    }

    private static String fixLengthString(String initString, int length, char padChar) {
        int currLength = initString.length();
        if (currLength == length) {
            return initString;
        }
        if (currLength > length) {
            return initString.substring(0, length);
        }
        char[] pad = new char[length - currLength];
        for (int i = 0; i < pad.length; ++i) {
            pad[i] = padChar;
        }
        return new String(pad);
    }

    static {
        nf2.setMinimumIntegerDigits(2);
        nf2.setMaximumIntegerDigits(2);
        nf4.setMinimumIntegerDigits(4);
        nf4.setGroupingUsed(false);
        nf5.setMinimumIntegerDigits(5);
        nf5.setMaximumIntegerDigits(5);
        nf5.setGroupingUsed(false);
        try {
            CUD_ZIP_FILE = BaseFileControl.getFilePath(CUD_ZIP_FILE) + CUD_ZIP_FILE;
            CKS_ZIP_FILE = BaseFileControl.getFilePath(CKS_ZIP_FILE) + CKS_ZIP_FILE;
            ACTP_ZIP_FILE = BaseFileControl.getFilePath(ACTP_ZIP_FILE) + ACTP_ZIP_FILE;
            LPARZ_ZIP_FILE = BaseFileControl.getFilePath(LPARZ_ZIP_FILE) + LPARZ_ZIP_FILE;
            LICCC_ZIP_FILE = BaseFileControl.getFilePath(LICCC_ZIP_FILE) + LICCC_ZIP_FILE;
            LPRDMP_TRM_FILE = BaseFileControl.getFilePath(LPRDMP_TRM_FILE) + LPRDMP_TRM_FILE;
            CECD_TRM_FILE = BaseFileControl.getFilePath(CECD_TRM_FILE) + CECD_TRM_FILE;
            CFDMP_TRM_FILE = BaseFileControl.getFilePath(CFDMP_TRM_FILE) + CFDMP_TRM_FILE;
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TsdUtils.static initializer: exception getting zip and trm filepaths", e, false);
        }
        int type = 2;
        try {
            byte[] simData = SimServer.getSimServer().readSim(5);
            if (simData != null && simData.length > 0) {
                type = simData[0];
            }
        }
        catch (Exception e) {
            TransmitSvcDataUtils.logError("TransmitSvcDatUtils.static: Exception reading XCPX_STATUS", e, false);
        }
        if (type == 5) {
            TKE = true;
        } else if (type == 1 || type == 3) {
            SE = true;
        } else {
            HMC = true;
        }
    }

    static class FileCounter {
        int counter = 0;

        FileCounter() {
        }

        int getValue() {
            return this.counter;
        }

        int increment() {
            return ++this.counter;
        }

        int decrement() {
            return --this.counter;
        }

        int reset() {
            int temp = this.counter;
            this.counter = 0;
            return temp;
        }
    }
}

